<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                           'Number', 
                'Order No', 
                'Invoice No',
                'Customer Name', 
                'Delivery Partner Name', 
                'Tracking ID'
                        ];
                    }
                    $query = "SELECT 
                    o.Order_id,
                    o.order_no,
                    o.Delivery_partner,
                    o.Tracking_id,
                    i.invoice_id,
                    i.invoice_no,
                    i.created_date,
                    u.displayname AS customer_name,
                    u.phoneno AS customer_mobile
              
            FROM 
                orders o
            LEFT JOIN 
                invoice i 
            ON 
                o.Invoice_id = i.invoice_id
            LEFT JOIN 
                customer u
            ON 
                o.User_id = u.id 
            WHERE 
                o.Delete_status = 0
                AND u.Delete_status = 0";
            
            // Apply duration filters (last week, last month, etc.)
            if ($duration == "Today") {
                $query .= " AND DATE(i.created_date) = CURDATE()";
            } elseif ($duration == "Yesterday") {
                $query .= " AND DATE(i.created_date) = CURDATE() - INTERVAL 1 DAY";
            } elseif ($duration == "Last Week") {
                $query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
            } elseif ($duration == "Last Month") {
                $query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
            } elseif ($duration == "Custom" && $startDate && $endDate) {
                $query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
            }
            // Perform the query using MySQLi
            $result = $conn->query($query);
            $data = [];
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            }
            
            // Generate the CSV file
            if ($reportFormat == "Xlsx") {
            $filePath = 'reports/whatsappbot_report_' . time() . '.csv';
            $file = fopen($filePath, 'w');
            
            // Write the header row
            $header = [
                'Number', 
                'Order No', 
                'Invoice No',
                'Customer Name', 
                'Delivery Partner Name', 
                'Tracking ID'
            ];
            
            
            fputcsv($file, $header);
            
             
            
            // Write data rows
            foreach ($data as $row) {
                
            fputcsv($file, [
                $row['customer_mobile'],               
                $row['order_no'],                 
                $row['invoice_no'],               
                $row['customer_name'],                
                $row['Delivery_partner'],               
                $row['Tracking_id']
            ]);
            }
            
            fclose($file);
            
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                      VALUES ('$reportNo','Whatsapp Bot Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);
            
            echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
            } elseif ($reportFormat == "pdf") {
            $filePath = 'reports/whatsapbot_report_' . time() . '.pdf';
            
            // Create a new PDF document
            $pdf = new FPDF('L', 'mm', array(250, 320));
            
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);
            
            // Table headers
            $headers = [
              'Number', 
                'Order No', 
                'Invoice No',
                'Customer Name', 
                'Delivery Partner Name', 
                'Tracking ID'
            ];
            
            
            // Set column widths
            $colWidths = array_fill(0, count($headers), 50); // Adjust column widths as needed
            $rowHeight = 8;
            
            // Print header row
            foreach ($headers as $index => $header) {
            $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row
            
            // Print data rows
            foreach ($data as $row) {
            
            $values = [
                $row['customer_mobile'],               
                $row['order_no'],                 
                $row['invoice_no'],               
                $row['customer_name'],                
                $row['Delivery_partner'],               
                $row['Tracking_id'] 
            ];
            
            foreach ($values as $index => $value) {
              $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row
            }
            
            // Save the PDF file
            $pdf->Output('F', $filePath);
            
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                     VALUES ('$reportNo','Whatsapp Bot Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);
            
            echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
            } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
            }
                }
            }
            ?>